/**
 * \file: MediaPlaybackStatusChannel.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: AAuto
 *
 * \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
 *
 * \copyright (c) 2013-2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTO_MEDIAPLAYBACKSTATUS_CHANNEL_H
#define AAUTO_MEDIAPLAYBACKSTATUS_CHANNEL_H

#include <aauto/GalReceiver.h>
#include <aauto/IMediaPlaybackStatusCallbacks.h>
#include <aauto/util/shared_ptr.h>
#include <aauto/AditMediaPlaybackStatus.h>

namespace adit { namespace aauto {

class MediaPlaybackStatusChannel : public IAditMediaPlaybackStatusCallbacks
{
public:
    MediaPlaybackStatusChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId);
    ~MediaPlaybackStatusChannel();

    void shutdown();
    bool Initialize();

    // inherit IAditMediaPlaybackStatusCallbacks
    int mediaPlaybackStatusCallback(struct MediaPlaybackStatusStruct inStatus);
    int mediaPlaybackMetadataCallback(struct MediaPlaybackMetadataStruct inMetadata);

    int mediaPlaybackReportAction(uint32_t inAction);

private:
    uint8_t mSessionId;
    ::shared_ptr<GalReceiver> mReceiver;
    ::shared_ptr<AditMediaPlaybackStatus> mEndpoint;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_MEDIAPLAYBACKSTATUS_CHANNEL_H */
